<aside id="sidebar" class="bg-white dark:bg-brand-dark w-64 flex-shrink-0 border-r border-gray-200 dark:border-white/5 flex flex-col transition-all duration-300 transform -translate-x-full md:translate-x-0 fixed md:relative z-50 h-full">
    
    <div class="h-20 flex items-center justify-center border-b border-gray-100 dark:border-white/5 relative">
        <img id="sidebar-logo" src="../public/img/logo-jfd.png" alt="JFD Logo" class="h-10 w-auto object-contain transition-all duration-300">
        
        <button onclick="toggleSidebar()" class="md:hidden absolute right-4 text-gray-500 hover:text-brand-red">
            <i class="ri-close-line text-2xl"></i>
        </button>
    </div>

    <nav class="flex-1 overflow-y-auto p-4 space-y-1">
        <?php 
            $current_page = basename($_SERVER['PHP_SELF']); 
            
            // Función para verificar si un item está activo
            function isActive($page_name, $current_page) {
                if ($page_name == 'productos' && in_array($current_page, ['productos.php', 'nuevo_producto.php', 'editar_producto.php'])) return true;
                if ($page_name == 'categorias' && in_array($current_page, ['categorias.php', 'nueva_categoria.php', 'editar_categoria.php'])) return true;
                if ($page_name == 'marcas' && in_array($current_page, ['marcas.php', 'nueva_marca.php', 'editar_marca.php'])) return true;
                if ($page_name == 'asesores' && in_array($current_page, ['asesores.php', 'nuevo_asesor.php', 'editar_asesor.php'])) return true;
                if ($page_name == 'usuarios' && in_array($current_page, ['usuarios.php', 'nuevo_usuario.php', 'editar_usuario.php'])) return true;
                if ($page_name . '.php' == $current_page) return true;
                return false;
            }

            $activeClass = "bg-brand-red/10 text-brand-red font-bold";
            $inactiveClass = "text-gray-600 dark:text-gray-400 font-medium";
        ?>

        <p class="px-4 text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] mb-2 mt-2">Principal</p>
        
        <a href="dashboard.php" class="flex items-center gap-3 px-4 py-3 hover:bg-gray-50 dark:hover:bg-white/5 hover:text-brand-red rounded-lg transition-colors group <?php echo isActive('dashboard', $current_page) ? $activeClass : $inactiveClass; ?>">
            <i class="ri-dashboard-3-fill text-xl"></i>
            <span>Dashboard</span>
        </a>

        <p class="px-4 text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] mb-2 mt-6">Gestión</p>
        
        <a href="productos.php" class="flex items-center gap-3 px-4 py-3 hover:bg-gray-50 dark:hover:bg-white/5 hover:text-brand-red rounded-lg transition-colors group <?php echo isActive('productos', $current_page) ? $activeClass : $inactiveClass; ?>">
            <i class="ri-speaker-3-line text-xl"></i>
            <span>Productos</span>
        </a>

        <a href="categorias.php" class="flex items-center gap-3 px-4 py-3 hover:bg-gray-50 dark:hover:bg-white/5 hover:text-brand-red rounded-lg transition-colors group <?php echo isActive('categorias', $current_page) ? $activeClass : $inactiveClass; ?>">
            <i class="ri-list-check-2 text-xl"></i>
            <span>Categorías</span>
        </a>

        <a href="marcas.php" class="flex items-center gap-3 px-4 py-3 hover:bg-gray-50 dark:hover:bg-white/5 hover:text-brand-red rounded-lg transition-colors group <?php echo isActive('marcas', $current_page) ? $activeClass : $inactiveClass; ?>">
            <i class="ri-price-tag-3-line text-xl"></i>
            <span>Marcas</span>
        </a>

        <p class="px-4 text-[10px] font-black text-gray-400 uppercase tracking-[0.2em] mb-2 mt-6">Personal</p>

        <a href="asesores.php" class="flex items-center gap-3 px-4 py-3 hover:bg-gray-50 dark:hover:bg-white/5 hover:text-brand-red rounded-lg transition-colors group <?php echo isActive('asesores', $current_page) ? $activeClass : $inactiveClass; ?>">
            <i class="ri-team-line text-xl"></i>
            <span>Asesores</span>
        </a>

        <?php if (isset($_SESSION['user_role']) && $_SESSION['user_role'] === 'admin'): ?>
            <a href="usuarios.php" class="flex items-center gap-3 px-4 py-3 hover:bg-gray-50 dark:hover:bg-white/5 hover:text-brand-red rounded-lg transition-colors group <?php echo isActive('usuarios', $current_page) ? $activeClass : $inactiveClass; ?>">
                <i class="ri-user-settings-line text-xl"></i>
                <span>Usuarios</span>
            </a>
        <?php endif; ?>
    </nav>

    <div class="p-4 border-t border-gray-100 dark:border-white/5">
        <a href="logout.php" class="flex items-center gap-3 px-4 py-3 text-gray-500 hover:text-red-500 hover:bg-red-50 dark:hover:bg-red-900/10 rounded-lg transition-colors">
            <i class="ri-logout-box-r-line text-xl"></i>
            <span class="font-bold">Cerrar Sesión</span>
        </a>
    </div>
</aside>

<div id="sidebar-overlay" onclick="toggleSidebar()" class="fixed inset-0 bg-black/50 z-40 hidden md:hidden glass-nav backdrop-blur-sm"></div>